////////////////////////////////////////////////////////////////////////////////
//
// © 1999 – 2019 OneSpan North America Inc. All rights reserved.
// All rights reserved. https://www.onespan.com/
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
NS_ASSUME_NONNULL_BEGIN

@class OrchestrationError;
@class OrchestrationServerError;

/**
 * <p>The {@link OrchestrationErrorDelegate} interface defines the delegate that must be implemented
 * in order to be informed of errors during the {@link OrchestrationProtocol} lifecycle.</p>
 * <p>Since it is the main way for the {@link OrchestrationProtocol} to report errors it must be provided to
 * the {@link OrchestratorBuilder} via
 * {@link OrchestratorBuilder#setErrorDelegate:(id<OrchestrationErrorDelegate>)}.<br/>
 * The {@link OrchestrationErrorDelegate} used by the {@link OrchestrationProtocol} can also be modified
 * during its lifecycle via {@link OrchestrationProtocol#setErrorDelegate:(id<OrchestrationErrorDelegate>)}.</p>
 */
NS_REFINED_FOR_SWIFT
@protocol OrchestrationErrorDelegate <NSObject>

/**
 * delegate that will be called when an error occurs
 * @param error error to return
 */
- (void)orchestrationError:(OrchestrationError*)error;

/**
 * delegate that will be called when an error occurrs on
 * the server and is sent back to the client
 * @param error error to be returned
 */
- (void)orchestrationServerError:(OrchestrationServerError*)error;


@end

NS_ASSUME_NONNULL_END
